/*
 * Decompiled with CFR 0.152.
 */
package com.dalet.log4shell;

import com.dalet.log4shell.Checksum;
import com.dalet.log4shell.Configuration;
import com.dalet.log4shell.Usage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ChecksumPatcher {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public static void main(String[] args) throws IOException {
        if (1 != args.length) {
            Usage.usage();
            return;
        }
        ChecksumPatcher.patchChkInDir(Paths.get(args[0], new String[0]));
    }

    public static void patchChkInDir(Path dir) throws IOException {
        ChecksumPatcher.patchChk(ChecksumPatcher.findChk(dir));
    }

    public static Path findChk(Path dir) throws IOException {
        Optional<Path> optionalChk = Files.list(dir).filter(path -> path.toString().endsWith(".chk")).findFirst();
        if (!optionalChk.isPresent()) {
            throw new IOException("Can't find *.chk in the " + dir);
        }
        Path chk = optionalChk.get();
        System.out.println("Detected: " + chk);
        return chk;
    }

    public static void patchChk(Path chk) throws IOException {
        String line;
        int lineCnt;
        System.out.println("Patching " + chk);
        List<String> lines = Files.readAllLines(chk);
        for (lineCnt = 0; lineCnt < lines.size() && !(line = lines.get(lineCnt)).equals("---"); ++lineCnt) {
            if (!ChecksumPatcher.needToFixLog4j(line)) continue;
            String log4jJarPathToken = line.split(";")[0];
            Path log4jJarPath = Paths.get(chk.getParent().toString(), log4jJarPathToken);
            String newCheckSumLine = log4jJarPathToken + ";" + Checksum.checksumFile(log4jJarPath);
            lines.set(lineCnt, newCheckSumLine);
            System.out.println("Replacing checksum: " + line + " by " + newCheckSumLine);
        }
        if (!lines.get(lineCnt).equals("---")) {
            throw new IOException("Malformed chk file " + chk + ". Can't find --- line");
        }
        if (!Configuration.isDryRun()) {
            String footer = lines.get(lineCnt + 2) + ". Patched by Dalet Log4J Patcher " + "1.3" + " on " + SIMPLE_DATE_FORMAT.format(new Date());
            try (BufferedWriter checksumWriter = new BufferedWriter(new FileWriter(chk.toString()));){
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < lineCnt; ++i) {
                    String line2 = lines.get(i);
                    sb.append(line2);
                    ChecksumPatcher.writeLine(checksumWriter, line2);
                }
                sb.append(footer);
                ChecksumPatcher.writeLine(checksumWriter, "---");
                ChecksumPatcher.writeLine(checksumWriter, "chk;" + Checksum.checkSumString(sb.toString()));
                ChecksumPatcher.writeLine(checksumWriter, footer);
            }
        } else {
            System.out.println("DRY RUN: " + chk + " won't be changed");
        }
        System.out.println("Patched chk: " + chk);
    }

    private static boolean needToFixLog4j(String line) {
        return line.startsWith("lib/log4j-core-2.");
    }

    private static void writeLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }
}

