/*
 * Decompiled with CFR 0.152.
 */
package com.dalet.log4shell;

import com.dalet.log4shell.AnyDirPatcher;
import com.dalet.log4shell.ChecksumPatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DaletJavaDirPatcher {
    public static void main(String[] args) throws Exception {
        if (1 != args.length) {
            DaletJavaDirPatcher.usage();
            return;
        }
        DaletJavaDirPatcher.patchDir(Paths.get(args[0], new String[0]));
    }

    private static void patchDir(Path dir) throws IOException {
        System.out.println("Pacthing all the affected log4j jars under " + dir + " dir and subfolders recusrively");
        AnyDirPatcher.patchDir(dir);
        System.out.println("Updating relevant checksums");
        Files.list(dir).filter(d -> d.toFile().isDirectory()).forEach(d -> {
            try {
                ChecksumPatcher.patchChkInDir(d);
            }
            catch (IOException e) {
                System.err.println("Can't patch " + d + ": " + e.getMessage());
            }
        });
    }

    public static void usage() {
        System.err.println("Patch log4j-core-[2.x].jar in the Galaxy java folder and update agent's signature. block CVE: https://en.wikipedia.org/wiki/Log4Shell");
        System.err.println("java -cp log4jpatcher-1.3.jar com.dalet.log4shell.DaletJavaDirPatcher <path to the Java folder>");
        System.err.println("Typical usage:");
        System.err.println("C:\\ProgramData\\DaletPlusData\\jre\\x64\\jre8\\bin\\java.exe -cp log4jpatcher-1.3.jar com.dalet.log4shell.DaletJavaDirPatcher \"C:\\Program Files\\Dalet\\DaletPlus\\bin\\java\"");
    }
}

