/*
 * Decompiled with CFR 0.152.
 */
package com.dalet.log4shell;

import com.dalet.log4shell.Configuration;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class Log4JCoreFilePatcher {
    public static final String JNDILOOKUP_CLASS_FILE = "org/apache/logging/log4j/core/lookup/JndiLookup.class";

    public static void patchLog4jJarIfNotPatched(Path log4jJarPath) throws IOException {
        try {
            Log4JCoreFilePatcher.patchLog4jJar(log4jJarPath);
        }
        catch (NoSuchFileException e) {
            System.out.println(log4jJarPath + " appears to be already patched: " + JNDILOOKUP_CLASS_FILE + " is not present");
        }
    }

    public static boolean needToFixLog4j(Path path) {
        if (null == path.getFileName()) {
            return false;
        }
        String fullName = path.getFileName().toString();
        if (!fullName.endsWith(".jar")) {
            return false;
        }
        if (!path.toFile().isFile()) {
            return false;
        }
        return fullName.startsWith("log4j-core-2.");
    }

    public static void patchLog4jJar(Path jar) throws IOException {
        System.out.println("Patching jar: " + jar);
        try (FileSystem zipfs = FileSystems.newFileSystem(jar, null);){
            if (Configuration.isDryRun()) {
                System.out.println("DRYRUN: JndiLookup.class exists: " + Files.exists(zipfs.getPath(JNDILOOKUP_CLASS_FILE, new String[0]), new LinkOption[0]));
            } else {
                Files.delete(zipfs.getPath(JNDILOOKUP_CLASS_FILE, new String[0]));
            }
            System.out.println("Patched jar: " + jar);
        }
    }
}

