/*
 * Decompiled with CFR 0.152.
 */
package com.dalet.util;

import com.dalet.util.InputStreamFinder;
import com.dalet.util.IntegrityCheckFailedExeption;
import com.dalet.util.JarUtils;
import com.dalet.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;

public class Adler32 {
    private static final Logger logger = new Logger();

    public static long get(InputStream is) throws IOException {
        try (CheckedInputStream cis = new CheckedInputStream(new BufferedInputStream(is), new java.util.zip.Adler32());){
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
    }

    public static String checkIntegrityFile(InputStream checkInputStream, InputStreamFinder inputSteamFinder) throws IOException, IntegrityCheckFailedExeption {
        HashMap<String, Long> adlers = new HashMap<String, Long>();
        ArrayList<String> files = new ArrayList<String>();
        StringBuilder moreLine = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        long adler = 0L;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(checkInputStream, "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ("---".equals(line)) {
                    String l = reader.readLine();
                    adler = Long.parseLong(l.split(";")[1]);
                    moreLine.append(reader.readLine());
                    break;
                }
                String[] parts = line.split(";");
                adlers.put(parts[0], Long.parseLong(parts[1]));
                files.add(parts[0]);
            }
            if (Adler32.verifyAdlerFileContent(files, adlers, adler, moreLine, errors, inputSteamFinder)) {
                String string = moreLine.toString();
                return string;
            }
            throw new IntegrityCheckFailedExeption(errors.toString());
        }
    }

    public static String checkMainJar(String jar, boolean verifyManifest, int prefixSize, String prefixReplacement) throws IOException, IntegrityCheckFailedExeption {
        jar = jar.replaceAll("\\%20", " ");
        logger.debug("Checking integrity of file " + jar);
        File jarFile = new File(jar);
        HashMap<String, Long> adlers = new HashMap<String, Long>();
        ArrayList<String> files = new ArrayList<String>();
        StringBuilder moreLine = new StringBuilder();
        StringBuilder errors = new StringBuilder();
        long adler = 0L;
        try {
            String string;
            BufferedReader reader;
            block21: {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jarFile.getAbsolutePath().replaceFirst("\\.jar$", ".chk")), "utf-8"));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ("---".equals(line)) {
                            String netxLine = reader.readLine();
                            if (null == netxLine) {
                                throw new IntegrityCheckFailedExeption("Invalid chk content: expected a line after '---'");
                            }
                            String[] nextLineParts = netxLine.split(";");
                            if (nextLineParts.length < 2) {
                                throw new IntegrityCheckFailedExeption("Invalid chk content: missing ';' in the line after '---'");
                            }
                            try {
                                adler = Long.parseLong(nextLineParts[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new IntegrityCheckFailedExeption("Invalid chk content: expected a number after ';' in the line after '---'");
                            }
                            String nextNextLine = reader.readLine();
                            if (null == nextNextLine) {
                                throw new IntegrityCheckFailedExeption("Invalid chk content: expected 2 lines after '---' bit got only one");
                            }
                            moreLine.append(nextNextLine);
                            break;
                        }
                        String[] parts = line.split(";");
                        if (parts.length < 2) {
                            throw new IntegrityCheckFailedExeption("Invalid chk content: missing ';'");
                        }
                        try {
                            long number = Long.parseLong(parts[1]);
                            adlers.put(parts[0], number);
                            files.add(parts[0]);
                        }
                        catch (NumberFormatException e) {
                            throw new IntegrityCheckFailedExeption("Invalid chk content: expected a number after ';'");
                        }
                    }
                    if (!Adler32.verifyAdlerFileContent(jarFile.getParentFile(), files, adlers, adler, moreLine, errors, prefixSize, prefixReplacement)) {
                        throw new IntegrityCheckFailedExeption(errors.toString());
                    }
                    if (!verifyManifest) break block21;
                    string = Adler32.verifyAllManifestFilesFoundInChkFile(jar, adlers, errors, moreLine);
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                reader.close();
                return string;
            }
            string = moreLine.toString();
            reader.close();
            return string;
        }
        finally {
            logger.debug("End checking integrity of file " + jar);
        }
    }

    private static String verifyAllManifestFilesFoundInChkFile(String jar, Map<String, Long> adlers, StringBuilder errors, StringBuilder moreLine) throws IOException, IntegrityCheckFailedExeption {
        HashSet<String> jarFiles = new HashSet<String>(JarUtils.getJarClassPath(jar));
        jarFiles.add(new File(jar).getName());
        for (String fileNameFromManifest : jarFiles) {
            if (adlers.keySet().contains(fileNameFromManifest)) continue;
            errors.append("Manifest file ").append(fileNameFromManifest).append(" does not exists in chk file\n");
        }
        if (errors.toString().trim().isEmpty()) {
            return moreLine.toString();
        }
        throw new IntegrityCheckFailedExeption(errors.toString());
    }

    private static boolean verifyAdlerFileContent(List<String> files, Map<String, Long> adlers, long adler, StringBuilder moreLine, StringBuilder errors, InputStreamFinder inputStreamFinder) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String file : files) {
            String fileName = new File(file).getName();
            logger.debug("Checking resource " + fileName);
            long buildTimeValue = Adler32.get(new BufferedInputStream(inputStreamFinder.find(fileName)));
            Long currentValue = adlers.get(file);
            if (buildTimeValue != currentValue && Adler32.notPatchedJars(fileName)) {
                errors.append("Resource ").append(fileName).append(" Was Modified, buildTimeValue:").append(buildTimeValue).append(" currentValue:").append(currentValue).append("\n");
            }
            sb.append(file).append(";").append(buildTimeValue);
        }
        sb.append((CharSequence)moreLine);
        if (adler != Adler32.get(new ByteArrayInputStream(sb.toString().getBytes("utf-8")))) {
            errors.append("The Check File itself was modified !!!");
            return false;
        }
        return errors.toString().trim().equals("");
    }

    private static boolean notPatchedJars(String fileName) {
        String lowerCase = fileName.toLowerCase();
        return !lowerCase.contains("axis2-kernel-1.4.1.jar") && !lowerCase.contains("axis-1.4.jar");
    }

    private static boolean verifyAdlerFileContent(File parentFile, List<String> files, Map<String, Long> adlers, long adler, StringBuilder moreLine, StringBuilder errors, int prefixSize, String prefixReplacment) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String file : files) {
            String absolutePath;
            File f;
            if (file.contains(":")) {
                if (0 < prefixSize && prefixSize < file.length()) {
                    String element = prefixReplacment + file.substring(prefixSize);
                    f = new File(element);
                } else {
                    f = new File(file);
                }
            } else {
                f = new File(parentFile, file);
            }
            long c = Adler32.get(new BufferedInputStream(new FileInputStream(f)));
            if (c != adlers.get(file) && Adler32.notPatchedJars(absolutePath = f.getAbsolutePath())) {
                errors.append("File ").append(absolutePath).append(" Was Modified\n");
            }
            sb.append(file).append(";").append(c);
        }
        sb.append((CharSequence)moreLine);
        return errors.toString().trim().isEmpty();
    }
}

