/*
 * Decompiled with CFR 0.152.
 */
package com.dalet.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class JarUtils {
    JarUtils() {
    }

    public static List<String> getJarClassPath(String jar) throws IOException {
        File file = new File(jar);
        JarFile jarfile = new JarFile(file);
        Manifest manifest = jarfile.getManifest();
        Attributes m = manifest.getMainAttributes();
        String classPath = (String)m.get(new Attributes.Name("Class-Path"));
        if (classPath == null) {
            return Collections.emptyList();
        }
        classPath = classPath.trim().replaceAll("\\\\", "/");
        String[] cp = classPath.split("\\s+");
        jarfile.close();
        return Arrays.asList(cp);
    }

    public static URL getContainerJar(Class cls) {
        String resource = cls.getName().replaceAll("\\.", "/") + ".class";
        URL url = cls.getClassLoader().getResource(resource);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getFile().split("!")[0]);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

