@echo off

if "%~1" == "" goto usage
set ACTIVE_VERSION=%~1
@rem eof input

SET LOG4JPATCHER_JAR=%~dp0log4jpatcher-1.3.jar
if not exist "%LOG4JPATCHER_JAR%" @echo "%LOG4JPATCHER_JAR% doesn't exist. Can't continue" >&2 && exit /B 1
SET DALETDATA=%PROGRAMDATA%\Dalet\Data
IF NOT EXIST "%PROGRAMDATA%\Dalet\Data" SET DALETDATA=%PROGRAMDATA%\DaletPlusData
SET java=%DALETDATA%\jre\x64\jre11\bin\java.exe
if NOT EXIST "%java%" SET java=%DALETDATA%\jre\x64\jre8\bin\java.exe
if NOT EXIST "%java%" @echo java.exe doesn't exist either in %DALETDATA%\jre\x64\jre11\bin or in %DALETDATA%\jre\x64\jre8\bin. Can't continue" >&2 && exit /b 1

for /d %%D IN ("%PROGRAMFILES%\Dalet\DaletPlus.*") DO (
    call :handle_dalet_dir "%%~D"
)


@echo --------------------------------------------------------------------
@echo * log4j-core jars in the previous installations have been modified correctly.*
@echo --------------------------------------------------------------------
exit /b 0

:handle_dalet_dir
    set dir=%~1
	@echo Working on %dir%
	if "%dir%" == "%PROGRAMFILES%\Dalet\DaletPlus" @echo Skipping %dir% because it is an active version && goto :EOF
	if "%dir%" == "%PROGRAMFILES%\Dalet\%ACTIVE_VERSION%" @echo Skipping %dir% because it is an active version && goto :EOF
	if NOT EXIST "%dir%\bin\java"  @echo Skipping %dir% because %dir%\bin\java doesn't exist && goto :EOF
    @echo Patching %dir%\bin\java
    call "%java%" -cp "%LOG4JPATCHER_JAR%" com.dalet.log4shell.DaletJavaDirPatcher "%dir%\bin\java"
    @echo Patched %dir%\bin\java
goto :EOF

:usage
@echo Usage: Run the batch with the active daletplus version folder as a parameter, in order to prevent the active version to be affected.
@echo Example: %0 DaletPlus.xxxxx
@echo Where xxxxx Is The ACTIVE Galaxy Version.
exit /B 1
