@echo off

SET LOG4JPATCHER_JAR=%~dp0log4jpatcher-1.3.jar
if not exist "%LOG4JPATCHER_JAR%" @echo "%LOG4JPATCHER_JAR% doesn't exist. Can't continue" >&2 && exit /B 1
SET DALETDATA=%PROGRAMDATA%\Dalet\Data
IF NOT EXIST "%PROGRAMDATA%\Dalet\Data" SET DALETDATA=%PROGRAMDATA%\DaletPlusData
SET java=%DALETDATA%\jre\x64\jre11\bin\java.exe
if NOT EXIST "%java%" SET java=%DALETDATA%\jre\x64\jre8\bin\java.exe
if NOT EXIST "%java%" @echo %java% doesn't exist. Can't continue" >&2 && exit /b 1

sc query daletservice
@if errorlevel 1060 (
@echo No DaletService.
) else (
	@echo Stopping DaletService, Please Wait...
	sc stop daletservice
	:loop
	sc query daletservice | findstr "STOPPED"
	@if errorlevel 1 (
	  @echo WAITING FOR DaletService to stop
	  @rem sleep ~1 sec
	  @ping 127.0.0.1 > null
	  @ goto loop
	)
	@echo DaletService is stopped. 

	)

@echo Patching "%PROGRAMFILES%\Dalet\DaletPlus\bin\java"
call "%java%" -cp "%LOG4JPATCHER_JAR%" com.dalet.log4shell.DaletJavaDirPatcher "%PROGRAMFILES%\Dalet\DaletPlus\bin\java"

@echo Patched "%PROGRAMFILES%\Dalet\DaletPlus\bin\java"
@echo Starting DaletService, Please Wait...

sc start  daletservice

@echo ------------------------------------------------------------------------------------------
@echo * Daletservice has been started and all the log4j-core jars have been modified correctly.*
@echo ------------------------------------------------------------------------------------------


exit /b 0
